#include "CMRControllerImpl.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/logger/CSFLogger.hpp"
#include "jcfcoreutils/StringUtils.h"
#include "csfunified/services/impl/BaseToImplCast.h"
#include "services/interface/CMRMeetingErrorCode.h"
#include "services/interface/CMRMeetingErrorCode_enum.h"
#include "CMRControllerMgr.h"
#include "../MeetingServiceImpl.h"
#include "csf/Base64.hpp"
#include "../MeetingServiceObjectManager.h"
#include "../meetingmgr/MeetingMgrControllerImplMac.h"
#include "../meetingmgr/MeetingMgrControllerImplWin.h"

namespace CSFUnified
{
	static CSFLogger* JabberCMRControllerLogger = CSFLogger_getLogger("MeetingService-JabberCMRController");

	CMRControllerImpl::CMRControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, const std::string JID) : CMRControllerBaseImpl(unifiedFactory)
	{
		m_JID = JID;
		m_isHost = false;
		m_isCMRInProgress = false;
		m_isWebExInLaunching = false;
		m_isWebExLaunched = false;
		m_isGroupChatExist = true;
		m_isNeedDelete = false;
		CSFLogDebugS(JabberCMRControllerLogger, "CMRControllerImpl::CMRControllerImpl this=" << this << ", m_JID=" << m_JID.c_str());
	}
		
	CMRControllerImpl::~CMRControllerImpl()
	{
		CSFLogDebugS(JabberCMRControllerLogger, "CMRControllerImpl::~CMRControllerImpl this=" << this);
	}

	std::string CMRControllerImpl::getJID()
	{
		return m_JID;
	}

	std::string CMRControllerImpl::getsipUrl()
	{
		return m_sipUrl;
	}

	std::string CMRControllerImpl::gethostPin()
	{
		return m_hostPin;
	}

	std::string CMRControllerImpl::getguestPin()
	{
		return m_guestPin;
	}

	std::string CMRControllerImpl::getjoinUrl()
	{
		return m_joinUrl;
	}

	std::string CMRControllerImpl::getjoinParam()
	{
		return m_joinParam;
	}

	void CMRControllerImpl::start(bool isAutoStartMeeting)
	{

		if (isAutoStartMeeting)
		{
			m_isHost = true;
			m_isCMRInProgress = true;
			m_isWebExLaunched = false;
			m_isWebExInLaunching = true;

            MeetingMgrControllerImpl * pMgr = MeetingServiceObjectManager::getInstance().getMeetingMgrController();
            if (NULL != pMgr)
            {
                pMgr->startCMRMeeting(true);
            }
		}
		else
		{
			if (isInvalidPMR(m_property))
			{
				updatePMRParam();
                CMRControllerMgr * pMgr = MeetingServiceObjectManager::getInstance().getCMRMgr();
                if (NULL != pMgr)
                {
                    pMgr->sendMeetingStarted(CMRMeetingErrorCodeEnum::CMR_SUCCESS, m_JID);
                }
			}
			else
			{
				m_isHost = true;
				m_isCMRInProgress = true;
				m_isWebExLaunched = false;
				m_isWebExInLaunching = false;
                MeetingMgrControllerImpl * pMgr = MeetingServiceObjectManager::getInstance().getMeetingMgrController();
                if (NULL != pMgr)
                {
                    pMgr->startCMRMeeting(false);
                }
			}
		}

		return;
	}

	void CMRControllerImpl::join(std::string joinParam)
	{
		m_isHost = false;
		m_isCMRInProgress = true;
		m_isWebExInLaunching = true;
		m_isWebExLaunched = false;
		std::string siteUrl = "";
		std::string siteName = "";
		std::string meetingKey = "";
		std::string mkgtk = "";

		decodeJoinParam(joinParam, siteUrl, siteName, meetingKey, mkgtk);
        
        MeetingMgrControllerImpl * pMgr = MeetingServiceObjectManager::getInstance().getMeetingMgrController();
        if (NULL != pMgr)
        {
            pMgr->joinCMRMeeting(siteUrl, meetingKey, mkgtk);
        }
		return;
	}

	bool CMRControllerImpl::onCmrMeetingStarted(const CMRMeetingData& info)
	{
		if (!m_isCMRInProgress)
		{
			return false;
		}

		m_isWebExLaunched = m_isWebExInLaunching;
		m_isWebExInLaunching = false;

		if (isInvalidPMR(m_property))
		{
			updatePMRParam();
		}
		else
		{
			updateCMRParam(info);
		}

		return true;
	}

	bool CMRControllerImpl::onCmrMeetingJoined()
	{
		if (!m_isCMRInProgress)
		{
			return false;
		}

		m_isWebExLaunched = m_isWebExInLaunching;
		m_isWebExInLaunching = false;
		return true;
	}

	bool CMRControllerImpl::onCmrMeetingError(bool& isHost)
	{
		if (!m_isCMRInProgress)
		{
			return false;
		}

		isHost = m_isHost;
		m_isHost = false;
		m_isCMRInProgress = false;
		m_isWebExInLaunching = false;
		m_isWebExLaunched = false;
        clearCMRParam();
		return true;
	}

	bool CMRControllerImpl::onCmrMeetingEnded()
	{
		if (!m_isCMRInProgress)
		{
			return false;
		}

		m_isHost = false;
		m_isCMRInProgress = false;
		m_isWebExInLaunching = false;
		m_isWebExLaunched = false;
		return true;
	}

	void CMRControllerImpl::clearCMRProperty()
	{
		m_property.isCMR = false;
		m_property.isPMR = false;
		m_property.fixedSipUrl = "";
		m_property.fixedHostPin = "";
		m_property.fixedJoinUrl = "";
		m_property.siteUrl = "";
		m_property.siteName = "";
		m_property.fixedMeetingKey = "";
		m_property.fixedAccessCode = "";
		CSFLogDebugS(JabberCMRControllerLogger, "CMRControllerImpl::clearCMRProperty this=" << this << ", m_property.fixedJoinUrl=" << m_property.fixedJoinUrl.c_str());
		return;
	}

	void CMRControllerImpl::setCMRProperty(CMRProperty& property)
	{
		m_property = property;
		CSFLogDebugS(JabberCMRControllerLogger, "CMRControllerImpl::setCMRProperty this=" << this << ", m_property.fixedJoinUrl=" << m_property.fixedJoinUrl.c_str());
	}

	bool CMRControllerImpl::isInvalidPMR(CMRProperty& property)
	{
		if (!property.isPMR || !property.isCMR)
		{
			return false;
		}

		if (property.fixedSipUrl.length() == 0 || property.fixedHostPin.length() == 0)
		{
			return false;
		}

		return true;
	}

    void CMRControllerImpl::clearCMRParam()
    {
        m_sipUrl = "";
        m_hostPin = "";
        m_guestPin = "";
        m_joinUrl = "";
        m_joinParam = "";
    }

    void CMRControllerImpl::updatePMRParam()
	{
		m_sipUrl = m_property.fixedSipUrl;
		m_hostPin = m_property.fixedHostPin;
		m_guestPin = "";
		m_joinUrl = m_property.fixedJoinUrl;
		m_joinParam = encodeJoinParam(m_property.siteUrl, m_property.siteName, m_property.fixedMeetingKey, "");
	}

	void CMRControllerImpl::updateCMRParam(const CMRMeetingData& info)
	{
        std::string JID = "";
        m_sipUrl = info.sipUrl.c_str();
        m_hostPin = info.hostKey.c_str();
		m_guestPin = "";
        m_joinUrl = info.joinUrl.c_str();
		m_joinParam = encodeJoinParam(m_property.siteUrl, m_property.siteName, info.meetingKey.c_str(), info.mtgtk.c_str());
	}

	std::string CMRControllerImpl::encodeJoinParam(const std::string siteUrl, const std::string siteName, const std::string meetingKey, const std::string mkgtk)
	{
		std::string param = "";
		setValueToJoinParam(param, "siteurl", siteUrl);
		setValueToJoinParam(param, "sitename", siteName);
		setValueToJoinParam(param, "meetingkey", meetingKey);
		setValueToJoinParam(param, "mkgtk", mkgtk);

		std::string joinParam = csf::base64_encode((unsigned char *)param.c_str(), param.size(), false);
		return joinParam;
	}

	void CMRControllerImpl::decodeJoinParam(std::string joinParam, std::string& siteUrl, std::string& siteName, std::string& meetingKey, std::string& mkgtk)
	{
		std::string param = "";
		std::vector<unsigned char> vecValue;
		csf::base64_decode(joinParam, vecValue);
		for (std::size_t i = 0; i < vecValue.size(); i++)
		{
			param += vecValue[i];
		}

		siteUrl = getValueFromJoinParam(param, "siteurl");
		siteName = getValueFromJoinParam(param, "sitename");
		meetingKey = getValueFromJoinParam(param, "meetingkey");
		mkgtk = getValueFromJoinParam(param, "mkgtk");

		return;
	}

	void CMRControllerImpl::setValueToJoinParam(std::string& joinParam, std::string tag, std::string value)
	{
		joinParam += "<";
		joinParam += tag;
		joinParam += ">";
		joinParam += value;
		joinParam += "</";
		joinParam += tag;
		joinParam += ">";

		return;
	}

	std::string CMRControllerImpl::getValueFromJoinParam(std::string joinParam, std::string tag)
	{
		std::string value = "";

		do
		{
			std::string flagStart = "<" + tag + ">";
			std::string flagEnd = "</" + tag + ">";
			int posStart = joinParam.find(flagStart);
			if (posStart < 0)
			{
				break;
			}
			posStart += flagStart.length();

			int posEnd = joinParam.find(flagEnd);
			if (posEnd <= posStart)
			{
				break;
			}

			value = joinParam.substr(posStart, posEnd - posStart);
		} while (0);

		return value;
	}
}

